<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:jmx="http://xml.kishou.go.jp/jmaxml1/" xmlns:jmx_ib="http://xml.kishou.go.jp/jmaxml1/informationBasis1/" xmlns:jmx_eb="http://xml.kishou.go.jp/jmaxml1/elementBasis1/" xmlns:jmx_mete="http://xml.kishou.go.jp/jmaxml1/body/meteorology1/" xmlns:jmx_add="http://xml.kishou.go.jp/jmaxml1/addition1/" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0">
<!--
  ======================================================================
  本スタイルシートは、気象庁防災情報XMLフォーマット形式電文中の全ての情報コンテンツを出力するもので、システム処理の動作確認など、電文処理の参考資料としてお使い下さい。

  なお、本スタイルシートについては、システムに直接組み込む等の方法でご利用になることは避けていただくなど、ご利用に当たっては十分に注意していただきますよう、よろしくお願いいたします。

  Copyright (c) 気象庁 2012 All rights reserved.
  
　【対象情報】
　早期天候情報

  【更新履歴】
  2013年01月29日　Ver.1.0
  2013年06月21日　Ver.1.1　降雪に関する情報の発表開始等に伴う変更
  2018年10月12日　Ver.1.2　早期天候情報対応
  2019年04月24日　Ver.1.3　5月1日より施行される新元号への対応
  ======================================================================
-->

<xsl:output method="html" indent="yes" />
<xsl:variable name="BR" select="'&#x0a;'" />


  <xsl:variable name="Title" select="/jmx:Report/jmx_ib:Head/jmx_ib:Title" />
  <xsl:variable name="HeadLine" select="/jmx:Report/jmx_ib:Head/jmx_ib:Headline/jmx_ib:Text" />

  <xsl:template match="/">

  <html>
  <head>
  <title>早期天候情報</title>
  </head>
  <body>
  <table border="1" width="75%" align="center" font-size="12pt">
  <tr><td style='font-family: monospace'>

    <!-- 電文基本要素 -->
    <xsl:apply-templates select="/jmx:Report/jmx_ib:Head" mode="Basic" />
    <br/>    
    <!-- 定型部分 -->
    <xsl:for-each select="//jmx_mete:MeteorologicalInfo/jmx_mete:Item">
          <xsl:choose>
            <xsl:when test="./jmx_mete:Kind/jmx_mete:Name='要早期警戒'">
<!--
		<xsl:choose>
		<xsl:when test="contains(./jmx_mete:Kind/jmx_mete:Property/jmx_mete:Type,'低温')">
		<xsl:text>要早期警戒（気温）</xsl:text>
		<br/>		
		</xsl:when>
		<xsl:when test="contains(./jmx_mete:Kind/jmx_mete:Property/jmx_mete:Type,'高温')">
		<xsl:text>要早期警戒（気温）</xsl:text>
		<br/>
		</xsl:when>
		<xsl:when test="contains(./jmx_mete:Kind/jmx_mete:Property/jmx_mete:Type,'大雪')">
		<xsl:text>要早期警戒（降雪量）</xsl:text>
		<br/>
		</xsl:when>
		</xsl:choose>
-->
<!--
		<xsl:text>警戒期間</xsl:text>
		<xsl:call-template name="blank1" />
		<xsl:value-of select="//jmx_mete:MeteorologicalInfo/jmx_mete:Name" />
		<br/>
-->
<!--
		<xsl:text>対象地域</xsl:text>
		<xsl:call-template name="blank1" />
-->
		<!-- 北海道で地域名が２つある場合 -->
		<xsl:if test="count(./jmx_mete:Areas/jmx_mete:Area)=2">
		<xsl:value-of select="./jmx_mete:Areas/jmx_mete:Area[position()=1]/jmx_mete:Name" />
		<xsl:text>、</xsl:text>
		<xsl:value-of select="./jmx_mete:Areas/jmx_mete:Area[position()=2]/jmx_mete:Name" />
		</xsl:if>
		<!-- それ以外 -->
                <xsl:if test="count(./jmx_mete:Areas/jmx_mete:Area)=1">
                <xsl:choose>
		<xsl:when test="count(./jmx_mete:Areas/jmx_mete:Area/jmx_mete:Name)=1">
		<xsl:value-of select="./jmx_mete:Areas/jmx_mete:Area/jmx_mete:Name" />
	        </xsl:when>
                <xsl:when test="count(./jmx_mete:Areas/jmx_mete:Area/jmx_mete:Name)=2">
		<xsl:value-of select="./jmx_mete:Areas/jmx_mete:Area/jmx_mete:Name[position()=1]" />
		<xsl:text>、</xsl:text>
		<xsl:value-of select="./jmx_mete:Areas/jmx_mete:Area/jmx_mete:Name[position()=2]" />		
		</xsl:when>
                </xsl:choose>
                </xsl:if>
<!--
		<br/>
-->
		<xsl:call-template name="blank1" />
          <xsl:call-template name="ZenNum">
            <xsl:with-param name="Num">
              <xsl:call-template name="DispDateTime2">
                <xsl:with-param name="Jikan" select="../jmx_mete:DateTime" />
              </xsl:call-template>
            </xsl:with-param>
          </xsl:call-template>
          <xsl:text>頃から</xsl:text>

		<xsl:call-template name="blank1" />
		<xsl:value-of select="./jmx_mete:Kind/jmx_mete:Property/jmx_mete:Type" />
		<br/>
<!--
		<xsl:text>警戒事項</xsl:text>
    		<xsl:call-template name="blank1" />
-->
		<xsl:if test=".//jmx_eb:SignificantClimateElement/@kind='気温'">
		<xsl:apply-templates select=".//jmx_mete:ClimateFeaturePart" mode="alertType" />
    		</xsl:if>
		<xsl:if test=".//jmx_eb:SignificantClimateElement/@kind='降雪量'">
		<xsl:apply-templates select=".//jmx_mete:ClimateFeaturePart" mode="alertType2" />
    		</xsl:if>
		<br/>
    		<!-- 確率行 -->
<!--
    		<xsl:text>確率</xsl:text>
    		<xsl:call-template name="blank3" />
    		<xsl:apply-templates select=".//jmx_eb:SignificantClimateElement/*[@unit='%']" mode="alertProb" />
    		<br/>
    		<br/>
-->
		<br/>              
            </xsl:when>
	    <!-- 早期警戒事項なしの場合 -->
            <xsl:when test="contains(./jmx_mete:Kind/jmx_mete:Name,'なし')">
	        <xsl:if test="string-length(.//jmx_eb:SignificantClimateElement/jmx_eb:Text/text()) &gt; 0">
                <xsl:text>早期警戒事項なし（</xsl:text>
	        <xsl:value-of select=".//jmx_eb:SignificantClimateElement/@kind" />
	        <xsl:text>）</xsl:text>
	        <br/>
	        <xsl:text>対象地域</xsl:text>
	        <xsl:call-template name="blank1" />
	        <!-- 北海道で地域名が２つある場合 -->
		<xsl:if test="count(./jmx_mete:Areas/jmx_mete:Area)=2">
		<xsl:value-of select="./jmx_mete:Areas/jmx_mete:Area[position()=1]/jmx_mete:Name" />
		<xsl:text>、</xsl:text>
		<xsl:value-of select="./jmx_mete:Areas/jmx_mete:Area[position()=2]/jmx_mete:Name" />
		</xsl:if>
		<!-- それ以外 -->
                <xsl:if test="count(./jmx_mete:Areas/jmx_mete:Area)=1">
                <xsl:choose>
		<xsl:when test="count(./jmx_mete:Areas/jmx_mete:Area/jmx_mete:Name)=1">
		<xsl:value-of select="./jmx_mete:Areas/jmx_mete:Area/jmx_mete:Name" />
	        </xsl:when>
                <xsl:when test="count(./jmx_mete:Areas/jmx_mete:Area/jmx_mete:Name)=2">
		<xsl:value-of select="./jmx_mete:Areas/jmx_mete:Area/jmx_mete:Name[position()=1]" />
		<xsl:text>、</xsl:text>
		<xsl:value-of select="./jmx_mete:Areas/jmx_mete:Area/jmx_mete:Name[position()=2]" />		
		</xsl:when>
                </xsl:choose>
                </xsl:if>
	        <br/>
                <xsl:text>警戒事項</xsl:text>
    		<xsl:call-template name="blank1" />
		<xsl:if test=".//jmx_eb:SignificantClimateElement/@kind='気温'">
		<xsl:apply-templates select=".//jmx_mete:ClimateFeaturePart" mode="alertType" />
    		</xsl:if>
		<xsl:if test=".//jmx_eb:SignificantClimateElement/@kind='降雪量'">
		<xsl:apply-templates select=".//jmx_mete:ClimateFeaturePart" mode="alertType2" />
    		</xsl:if>
		<br/>
    	        <!-- 確率行 -->
    	        <xsl:text>確率</xsl:text>
    	        <xsl:call-template name="blank3" />
    	        <xsl:apply-templates select=".//jmx_eb:SignificantClimateElement/*[@unit='%']" mode="alertProb" />
    	        <br/>
    	        <br/>
	        <br/>
	        </xsl:if>
            </xsl:when>
        </xsl:choose>
    </xsl:for-each>
    <!-- 解説行 -->
    <xsl:call-template name="mkDanraku">
      <xsl:with-param name="str" select="//jmx_mete:MeteorologicalInfo//jmx_mete:Text" />
    </xsl:call-template>
    <!-- 末尾の'=' -->
    <xsl:text>=</xsl:text>

    </td></tr>
    </table></body></html>

  </xsl:template>
  <!-- ====================== -->
  <!-- 電文基本要素テンプレート -->
  <!-- ====================== -->
  <xsl:template match="/jmx:Report/jmx_ib:Head" mode="Basic">
    <!-- 発表状況 -->
    <xsl:if test="contains(jmx_ib:InfoType,'訂正')">
      <xsl:call-template name="blank1" />
      <xsl:text>（訂正）</xsl:text>
      <br/>
    </xsl:if>
    <!-- 標題行 -->
    <xsl:value-of select="jmx_ib:Title" />
    <br/>
    <!-- 発表日時行 -->
    <xsl:call-template name="ZenNum">
      <xsl:with-param name="Num">
        <xsl:call-template name="DispDateTime1">
          <xsl:with-param name="Jikan" select="jmx_ib:ReportDateTime" />
        </xsl:call-template>
      </xsl:with-param>
    </xsl:call-template>
    <br/>
    <!-- 発表官署行 -->
    <xsl:call-template name="DispPublishingOffice">
      <xsl:with-param name="OfficeStr" select="/jmx:Report/jmx:Control/jmx:PublishingOffice" />
    </xsl:call-template>
    <xsl:call-template name="blank1" />
    <xsl:text>発表</xsl:text>
    <br/>
  </xsl:template>
  <!-- ...................... -->
  <!-- 発表官署表示テンプレート -->
  <xsl:template name="DispPublishingOffice">
    <xsl:param name="OfficeStr">dummy</xsl:param>
    <xsl:choose>
      <xsl:when test="starts-with($OfficeStr, '気象庁')">
        <xsl:call-template name="SepareteWithSpc">
          <xsl:with-param name="TargetString" select="$OfficeStr" />
          <xsl:with-param name="Anchor">気象庁 </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$OfficeStr" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- ================== -->
  <!-- 対象地域テンプレート -->
  <!-- ================== -->
  <xsl:template match="//jmx_ib:Head//jmx_ib:Area" mode="tgtAreas">
    <xsl:if test="position() &gt; 1">
      <xsl:text>、</xsl:text>
    </xsl:if>
    <xsl:value-of select="jmx_ib:Name" />
  </xsl:template>
  <!-- =================== -->
  <!-- 警戒事項テンプレート -->
  <!-- =================== -->
  <xsl:template match="//jmx_mete:MeteorologicalInfo//jmx_mete:ClimateFeaturePart" mode="alertType">
    <xsl:value-of select="../jmx_mete:Type" />
<!--
    <xsl:text>（７日平均地域平年差</xsl:text>
-->
    <xsl:text>の基準：５日間平均気温平年差</xsl:text>
    <xsl:variable name="aboveStr">
      <xsl:apply-templates select="./*/jmx_eb:ThresholdOfSignificantlyAboveNormal" mode="threshold" />
    </xsl:variable>
    <xsl:variable name="belowStr">
      <xsl:apply-templates select="./*/jmx_eb:ThresholdOfSignificantlyBelowNormal" mode="threshold" />
    </xsl:variable>
    <xsl:if test="string-length($aboveStr) &gt; 0">
      <xsl:value-of select="concat('＋', $aboveStr)" />
      <xsl:if test="string-length($belowStr) &gt; 0">
        <xsl:text>、</xsl:text>
      </xsl:if>
    </xsl:if>
    <xsl:value-of select="$belowStr" />
<!--
    <xsl:text>）</xsl:text>
-->
  </xsl:template>
  <xsl:template match="*" mode="threshold">
    <xsl:call-template name="ZenNum">
      <xsl:with-param name="Num" select="format-number(., '#0.0')" />    
    </xsl:call-template>
   <xsl:call-template name="ZenNum">
   <xsl:with-param name="Num">
    <xsl:value-of select="@unit" />
    <xsl:value-of select="@bound" />
   </xsl:with-param>
   </xsl:call-template>
  </xsl:template>
  <!-- =================== -->
  <!-- 警戒事項テンプレート2 -->
  <!-- =================== -->
  <xsl:template match="//jmx_mete:MeteorologicalInfo//jmx_mete:ClimateFeaturePart" mode="alertType2">
    <xsl:value-of select="../jmx_mete:Type" />
<!--
    <xsl:text>（７日合計地域平年比</xsl:text>
-->
    <xsl:text>の基準：５日間合計降雪量平年比</xsl:text>
    <xsl:variable name="aboveStr">
      <xsl:apply-templates select="./*/jmx_eb:ThresholdOfSignificantlyAboveNormal" mode="threshold2" />
    </xsl:variable>    
    <xsl:if test="string-length($aboveStr) &gt; 0">
      <xsl:value-of select="concat('', $aboveStr)" />      
    </xsl:if>    
<!--
    <xsl:text>）</xsl:text>
-->
  </xsl:template>
  <xsl:template match="*" mode="threshold2">
    <xsl:call-template name="ZenNum">
      <xsl:with-param name="Num" select="format-number(., '#')" />   
    </xsl:call-template>
    <xsl:call-template name="ZenNum">
    <xsl:with-param name="Num">
    <xsl:value-of select="@unit" />
    <xsl:value-of select="@bound" />
    </xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <!-- ================= -->
  <!-- 確率行テンプレート -->
  <!-- ================= -->
  <xsl:template match="jmx_eb:SignificantClimateElement/*" mode="alertProb">
    <xsl:if test="position() = 1">
      <xsl:call-template name="ZenNum">
        <xsl:with-param name="Num">
          <xsl:value-of select="." />
          <xsl:value-of select="@unit" />
          <xsl:value-of select="@bound" />
        </xsl:with-param>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
  <!-- ============================================== -->
  <!-- アンカー文字列による全角スペース区切りテンプレート -->
  <!-- ============================================== -->
  <xsl:template name="SepareteWithSpc">
    <xsl:param name="TargetString">dummy1</xsl:param>
    <xsl:param name="Anchor">dummy2</xsl:param>
    <xsl:param name="AnchorBody" select="translate($Anchor, ' ', '')" />
    <xsl:call-template name="ZenNum">
      <xsl:with-param name="Num" select="substring-before($TargetString, $AnchorBody)" />
    </xsl:call-template>
    <xsl:choose>
      <xsl:when test="starts-with($Anchor, ' ')">
        <xsl:call-template name="blank1" />
        <xsl:value-of select="$AnchorBody" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$AnchorBody" />
        <xsl:call-template name="blank1" />
      </xsl:otherwise>
    </xsl:choose>
    <xsl:call-template name="ZenNum">
      <xsl:with-param name="Num" select="substring-after($TargetString, $AnchorBody)" />
    </xsl:call-template>
  </xsl:template>
  <!-- ========================== -->
  <!-- 日付表示テンプレート(分単位) -->
  <!-- ========================== -->
  <xsl:template name="DispDateTime1">
    <xsl:param name="Jikan">dummy</xsl:param>
    <xsl:text>令和</xsl:text>
    <xsl:if test="number(substring($Jikan,1,4))=2019">
      <xsl:text>元</xsl:text>
    </xsl:if>
    <xsl:if test="number(substring($Jikan,1,4))!=2019">
      <xsl:value-of select="number(substring($Jikan,1,4)) - 2018 " />
    </xsl:if>
    <xsl:text>年</xsl:text>
    <xsl:value-of select="number(substring($Jikan,6,2))" />
    <xsl:text>月</xsl:text>
    <xsl:value-of select="number(substring($Jikan,9,2))" />
    <xsl:text>日</xsl:text>
    <xsl:value-of select="substring($Jikan,12,2)" />
    <xsl:text>時</xsl:text>
    <xsl:value-of select="substring($Jikan,15,2)" />
    <xsl:text>分</xsl:text>
  </xsl:template>
  <!-- ========================== -->
  <!-- 日付表示テンプレート(日単位まで) -->
  <!-- ========================== -->
  <xsl:template name="DispDateTime2">
    <xsl:param name="Jikan">dummy</xsl:param>
    <xsl:value-of select="number(substring($Jikan,6,2))" />
    <xsl:text>月</xsl:text>
    <xsl:value-of select="number(substring($Jikan,9,2))" />
    <xsl:text>日</xsl:text>
  </xsl:template>
  <!-- ====================== -->
  <!-- 全角数字表示テンプレート -->
  <!-- ====================== -->
  <xsl:template name="ZenNum">
    <xsl:param name="Num">dummy</xsl:param>
    <xsl:value-of select="translate($Num, '.+-%0123456789', '．＋－％０１２３４５６７８９')" />
  </xsl:template>
  <!-- ========================== -->
  <!-- 全角スペース表示テンプレート -->
  <!-- ========================== -->
  <xsl:template name="blank1">
    <xsl:text>　</xsl:text>
  </xsl:template>
  <xsl:template name="blank2">
    <xsl:text>　　</xsl:text>
  </xsl:template>
  <xsl:template name="blank3">
    <xsl:text>　　　</xsl:text>
  </xsl:template>
  <xsl:template name="blank4">
    <xsl:text>　　　　</xsl:text>
  </xsl:template>
  <xsl:template name="blank5">
    <xsl:text>　　　　　</xsl:text>
  </xsl:template>
  <xsl:template name="blank6">
    <xsl:text>　　　　　　</xsl:text>
  </xsl:template>
  <xsl:template name="blanks">
    <xsl:param name="n">0</xsl:param>
    <xsl:if test="$n &gt; 0">
      <xsl:call-template name="blank1" />
      <xsl:call-template name="blanks">
        <xsl:with-param name="n" select="$n - 1" />
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
  <!-- ============================================ -->
  <!-- 段落（１行３４文字）表示テンプレート           -->
  <!--   jisage = 0: １行目の字下げ無し              -->
  <!--   jisage = 1: １行目の字下げあり              -->
  <!--   jisage = 2: １段落めは字下げ無し、          -->
  <!--               ２段落め以後は１行目の字下げあり -->
  <!--    ※ 禁則処理は $KinsokuChars で制御する     -->
  <!-- ============================================ -->
  <xsl:variable name="KinsokuChars" select="''" />
  <!--
<xsl:variable name="KinsokuChars" select="'、。'" />
-->
  <xsl:template name="mkDanraku">
    <xsl:param name="str">dummy</xsl:param>
    <xsl:param name="jisage">0</xsl:param>
    <xsl:choose>
      <xsl:when test="starts-with($str, '＜')">
        <xsl:call-template name="mkDanraku1">
          <xsl:with-param name="str" select="$str" />
          <xsl:with-param name="jisage" select="$jisage" />
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="mkDanraku1">
          <xsl:with-param name="str">
            <xsl:if test="$jisage = 1 and string-length($str) &gt; 0">
              <xsl:call-template name="blank1" />
            </xsl:if>
            <xsl:value-of select="$str" />
          </xsl:with-param>
          <xsl:with-param name="jisage" select="$jisage" />
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="mkDanraku1">
    <xsl:param name="str">dummy</xsl:param>
    <xsl:param name="jisage">0</xsl:param>
    <xsl:variable name="jisage2">
      <xsl:choose>
        <xsl:when test="$jisage = 2">
          <xsl:value-of select="1" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$jisage" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="contains($str, $BR)">
        <xsl:call-template name="mkLine">
          <xsl:with-param name="danraku" select="substring-before($str, $BR)" />
        </xsl:call-template>
        <xsl:call-template name="mkDanraku">
          <xsl:with-param name="str" select="substring-after($str, $BR)" />
          <xsl:with-param name="jisage" select="$jisage2" />
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="mkLine">
          <xsl:with-param name="danraku" select="$str" />
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="mkLine">
    <xsl:param name="danraku">dummy</xsl:param>
    <xsl:variable name="len" select="string-length($danraku)" />
    <xsl:choose>
      <xsl:when test="$len = 0" />
      <xsl:when test="$len &lt; 35">
        <xsl:value-of select="$danraku" />
        <br/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="kaigyoPos">
          <xsl:choose>
            <xsl:when test="string-length($KinsokuChars) &gt; 0 and                            contains($KinsokuChars,                              substring(substring($danraku, 35), 1, 1) )">
              <xsl:value-of select="33" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="34" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:value-of select="substring($danraku, 1, $kaigyoPos)" />
        <br/>
        <xsl:call-template name="mkLine">
          <xsl:with-param name="danraku" select="substring($danraku, $kaigyoPos + 1)" />
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>